/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.mainmenu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.data.IAttributeSet;
import noppes.npcs.api.entity.data.IDropNbtSet;
import noppes.npcs.api.entity.data.IEnchantSet;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.drop.SubGuiDropAttribute;
import noppes.npcs.client.gui.drop.SubGuiDropEnchant;
import noppes.npcs.client.gui.drop.SubGuiDropValueNbt;
import noppes.npcs.client.gui.select.GuiQuestSelection;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface2;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.containers.ContainerNPCDropSetup;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.AttributeSet;
import noppes.npcs.entity.data.DropNbtSet;
import noppes.npcs.entity.data.DropSet;
import noppes.npcs.entity.data.EnchantSet;

public class GuiDropEdit
extends GuiContainerNPCInterface2
implements ICustomScrollListener,
ISubGuiListener,
ITextfieldListener {
    private final GuiContainer parent;
    public DropSet drop;
    private Map<String, AttributeSet> attributesData;
    private Map<String, EnchantSet> enchantData;
    private Map<String, DropNbtSet> tagsData;
    private AttributeSet attribute;
    private EnchantSet enchant;
    private DropNbtSet tag;
    public int dropType;
    public int groupId;
    public int slot;
    private int reset;
    private int[] amount;
    private GuiCustomScroll scrollAttributes;
    private GuiCustomScroll scrollEnchants;
    private GuiCustomScroll scrollTags;

    public GuiDropEdit(EntityNPCInterface npc, ContainerNPCDropSetup cont, GuiContainer gui, int dropType, int groupId, int pos) {
        super(npc, (Container)cont);
        this.field_147000_g = 200;
        this.closeOnEsc = true;
        this.setBackground("npcdrop.png");
        this.parent = gui;
        this.dropType = dropType;
        this.groupId = groupId;
        this.slot = pos;
        this.drop = cont.inventoryDS;
        this.scrollEnchants = null;
        this.scrollAttributes = null;
        this.scrollTags = null;
        this.reset = 0;
        this.amount = new int[]{this.drop.getMinAmount(), this.drop.getMaxAmount()};
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        GuiNpcTextField.unfocus();
        switch (button.getID()) {
            case 0: {
                this.drop.resetTo(this.drop.item);
                this.func_73866_w_();
                break;
            }
            case 1: {
                this.enchant = (EnchantSet)this.drop.addEnchant(0);
                this.setSubGui(new SubGuiDropEnchant(this.enchant));
                break;
            }
            case 2: {
                this.drop.removeEnchant(this.enchantData.get(this.scrollEnchants.getSelected()));
                this.func_73866_w_();
                break;
            }
            case 3: {
                this.setSubGui(new SubGuiDropEnchant(this.enchant));
                break;
            }
            case 4: {
                this.attribute = (AttributeSet)this.drop.addAttribute("");
                this.setSubGui(new SubGuiDropAttribute(this.attribute));
                break;
            }
            case 5: {
                this.drop.removeAttribute(this.attributesData.get(this.scrollAttributes.getSelected()));
                this.func_73866_w_();
                break;
            }
            case 6: {
                this.setSubGui(new SubGuiDropAttribute(this.attribute));
                break;
            }
            case 7: {
                this.tag = (DropNbtSet)this.drop.addDropNbtSet(0, 100.0, "", new String[0]);
                this.setSubGui(new SubGuiDropValueNbt(this.tag));
                break;
            }
            case 8: {
                this.drop.removeDropNbt(this.tagsData.get(this.scrollTags.getSelected()));
                this.func_73866_w_();
                break;
            }
            case 9: {
                this.setSubGui(new SubGuiDropValueNbt(this.tag));
                break;
            }
            case 10: {
                this.drop.setLootMode(button.getValue());
                break;
            }
            case 11: {
                this.drop.setTiedToLevel(button.getValue() == 1);
                break;
            }
            case 12: {
                this.setSubGui(new GuiQuestSelection(this.drop.questId));
            }
        }
    }

    @Override
    public void close() {
        GuiNpcTextField.unfocus();
        if (this.parent != null) {
            this.save();
            this.displayGuiScreen((GuiScreen)this.parent);
        } else {
            super.close();
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.reset > 0) {
            --this.reset;
            if (this.reset == 0) {
                this.func_73866_w_();
            }
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.subgui != null) {
            return;
        }
        this.field_147002_h.func_75139_a(0);
        if (this.getButton(0) != null) {
            ItemStack stack = this.field_147002_h.func_75139_a(0).func_75211_c();
            GuiNpcButton button = (GuiNpcButton)this.getButton(0);
            if (button.field_146124_l && stack.func_190926_b()) {
                this.drop.item = Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(stack);
            } else if (!button.field_146124_l && !stack.func_190926_b()) {
                this.drop.item = Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(stack);
            }
        }
        if (!CustomNpcs.ShowDescriptions) {
            return;
        }
        String tied = new TextComponentTranslation("drop.tied.random", new Object[0]).func_150254_d();
        if (this.drop.tiedToLevel) {
            tied = new TextComponentTranslation("drop.tied.level", new Object[0]).func_150254_d();
        }
        if (this.isMouseHover(mouseX, mouseY, this.field_147003_i + 368, this.field_147009_r + 138, 46, 24)) {
            this.drawHoverText("drop.hover.amount", tied);
        } else if (this.isMouseHover(mouseX, mouseY, this.field_147003_i + 270, this.field_147009_r + 171, 46, 16)) {
            this.drawHoverText("drop.hover.break", tied);
        } else if (this.getTextField(4) != null && this.getTextField(4).isHovered()) {
            Quest quest = QuestController.instance.quests.get(this.getTextField(4).getInteger());
            if (quest != null) {
                this.drawHoverText("drop.hover.quest", quest.getName());
            } else {
                this.drawHoverText("drop.hover.any.quest", new Object[0]);
            }
        }
    }

    protected void func_184098_a(@Nonnull Slot slotIn, int slotId, int mouseButton, @Nonnull ClickType type) {
        super.func_184098_a(slotIn, slotId, mouseButton, type);
        this.reset = 3;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.parent == null) {
            this.close();
            return;
        }
        int anyIDs = 0;
        GuiNpcLabel label = new GuiNpcLabel(anyIDs++, "drop.slot", this.field_147003_i + 171, this.field_147009_r + 139);
        label.setHoverText("drop.hover.slot", new Object[0]);
        this.addLabel(label);
        this.addLabel(new GuiNpcLabel(anyIDs++, "drop.chance", this.field_147003_i + 229, this.field_147009_r + 145));
        GuiNpcTextField chance = new GuiNpcTextField(0, (GuiScreen)this, this.field_147003_i + 268, this.field_147009_r + 140, 50, 20, String.valueOf(this.drop.getChance()));
        chance.setMinMaxDoubleDefault(1.0E-4, 100.0, this.drop.getChance());
        chance.func_146184_c(!this.drop.item.isEmpty());
        chance.setHoverText("drop.hover.chance", new Object[0]);
        this.addTextField(chance);
        boolean needReAmount = false;
        this.amount = this.drop.amount;
        if (this.drop.getMinAmount() > this.drop.item.getMaxStackSize()) {
            this.amount[0] = this.drop.item.getMaxItemDamage();
            needReAmount = true;
        } else if (this.drop.getMinAmount() <= 0) {
            this.amount[0] = 1;
            needReAmount = true;
        }
        if (this.drop.getMaxAmount() > this.drop.item.getMaxStackSize()) {
            this.amount[1] = this.drop.item.getMaxStackSize();
            needReAmount = true;
        } else if (this.drop.getMaxAmount() <= 0) {
            this.amount[1] = 1;
            needReAmount = true;
        }
        if (needReAmount) {
            this.drop.setAmount(this.amount[0], this.amount[1]);
        }
        this.addLabel(new GuiNpcLabel(anyIDs++, "drop.amount", this.field_147003_i + 329, this.field_147009_r + 145));
        GuiNpcTextField countMin = new GuiNpcTextField(1, (GuiScreen)this, this.field_147003_i + 366, this.field_147009_r + 136, 50, 14, "" + this.amount[0]);
        countMin.setMinMaxDefault(1L, this.drop.item.getMaxStackSize(), this.drop.item.getStackSize());
        countMin.func_146184_c(!this.drop.item.isEmpty());
        this.addTextField(countMin);
        GuiNpcTextField countMax = new GuiNpcTextField(2, (GuiScreen)this, this.field_147003_i + 366, this.field_147009_r + 150, 50, 14, "" + this.amount[1]);
        countMax.setMinMaxDefault(1L, this.drop.item.getMaxStackSize(), this.drop.item.getStackSize());
        countMax.func_146184_c(!this.drop.item.isEmpty());
        this.addTextField(countMax);
        this.addLabel(new GuiNpcLabel(anyIDs++, "drop.break", this.field_147003_i + 229, this.field_147009_r + 174));
        GuiNpcTextField damage = new GuiNpcTextField(3, (GuiScreen)this, this.field_147003_i + 268, this.field_147009_r + 169, 50, 20, String.valueOf(this.drop.getDamage()));
        damage.setMinMaxDoubleDefault(0.0, 1.0, this.drop.getDamage());
        damage.func_146184_c(this.drop.item.getMaxItemDamage() != 0);
        this.addTextField(damage);
        GuiNpcButton button = new GuiNpcButton(0, this.field_147003_i + 171, this.field_147009_r + 169, 48, 20, "remote.reset", !this.drop.item.isEmpty());
        button.setHoverText("drop.hover.reset", new Object[0]);
        this.addButton(button);
        label = new GuiNpcLabel(anyIDs++, "drop.enchants", this.field_147003_i + 4, this.field_147009_r + 5);
        label.setHoverText("drop.hover.enchants", new Object[0]);
        this.addLabel(label);
        HashMap<String, EnchantSet> newEnchData = new HashMap<String, EnchantSet>();
        for (IEnchantSet ies : this.drop.getEnchantSets()) {
            newEnchData.put(((EnchantSet)ies).getKey(), (EnchantSet)ies);
        }
        this.enchantData = newEnchData;
        if (this.scrollEnchants == null) {
            this.scrollEnchants = new GuiCustomScroll(this, 0);
            this.scrollEnchants.setSize(133, 93);
        }
        this.scrollEnchants.setList(new ArrayList<String>(this.enchantData.keySet()));
        this.scrollEnchants.guiLeft = this.field_147003_i + 4;
        this.scrollEnchants.guiTop = this.field_147009_r + 16;
        if (this.enchant != null) {
            this.scrollEnchants.setSelected(this.enchant.getKey());
        }
        this.addScroll(this.scrollEnchants);
        button = new GuiNpcButton(1, this.field_147003_i + 4, this.field_147009_r + 112, 43, 20, "gui.add", !this.drop.item.isEmpty() && this.enchantData.size() <= 16);
        button.setHoverText("drop.hover.enchant.add", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(2, this.field_147003_i + 4 + 45, this.field_147009_r + 112, 43, 20, "gui.remove", this.scrollEnchants.getSelected() != null);
        button.setHoverText("drop.hover.enchant.del", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(3, this.field_147003_i + 4 + 91, this.field_147009_r + 112, 43, 20, "selectServer.edit", this.scrollEnchants.getSelected() != null);
        button.setHoverText("drop.hover.enchant.edit", new Object[0]);
        this.addButton(button);
        label = new GuiNpcLabel(anyIDs++, "drop.attributes", this.field_147003_i + 143, this.field_147009_r + 5);
        label.setHoverText("drop.hover.attributes", new Object[0]);
        this.addLabel(label);
        HashMap<String, AttributeSet> newAttrData = new HashMap<String, AttributeSet>();
        for (IAttributeSet ias : this.drop.getAttributeSets()) {
            newAttrData.put(((AttributeSet)ias).getKey(), (AttributeSet)ias);
        }
        this.attributesData = newAttrData;
        if (this.scrollAttributes == null) {
            this.scrollAttributes = new GuiCustomScroll(this, 1);
            this.scrollAttributes.setSize(133, 93);
        }
        this.scrollAttributes.setList(new ArrayList<String>(this.attributesData.keySet()));
        this.scrollAttributes.guiLeft = this.field_147003_i + 143;
        this.scrollAttributes.guiTop = this.field_147009_r + 16;
        if (this.attribute != null) {
            this.scrollAttributes.setSelected(this.attribute.getKey());
        }
        this.addScroll(this.scrollAttributes);
        button = new GuiNpcButton(4, this.field_147003_i + 143, this.field_147009_r + 112, 43, 20, "gui.add", !this.drop.item.isEmpty() && this.attributesData.size() <= 16);
        button.setHoverText("drop.hover.attribute.add", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(5, this.field_147003_i + 143 + 45, this.field_147009_r + 112, 44, 20, "gui.remove", this.scrollAttributes.getSelected() != null);
        button.setHoverText("drop.hover.attribute.del", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(6, this.field_147003_i + 143 + 91, this.field_147009_r + 112, 43, 20, "selectServer.edit", this.scrollAttributes.getSelected() != null);
        button.setHoverText("drop.hover.attribute.edit", new Object[0]);
        this.addButton(button);
        label = new GuiNpcLabel(anyIDs++, "drop.tags", this.field_147003_i + 283, this.field_147009_r + 5);
        label.setHoverText("drop.hover.tags", new Object[0]);
        this.addLabel(label);
        HashMap<String, DropNbtSet> newTagsData = new HashMap<String, DropNbtSet>();
        for (IDropNbtSet dns : this.drop.getDropNbtSets()) {
            newTagsData.put(((DropNbtSet)dns).getKey(), (DropNbtSet)dns);
        }
        this.tagsData = newTagsData;
        if (this.scrollTags == null) {
            this.scrollTags = new GuiCustomScroll(this, 2);
            this.scrollTags.setSize(133, 93);
        }
        this.scrollTags.setList(new ArrayList<String>(this.tagsData.keySet()));
        this.scrollTags.guiLeft = this.field_147003_i + 283;
        this.scrollTags.guiTop = this.field_147009_r + 16;
        if (this.tag != null) {
            this.scrollTags.setSelected(this.tag.getKey());
        }
        this.addScroll(this.scrollTags);
        button = new GuiNpcButton(7, this.field_147003_i + 283, this.field_147009_r + 112, 43, 20, "gui.add", !this.drop.item.isEmpty() && this.tagsData.size() <= 24);
        button.setHoverText("drop.hover.tag.add", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(8, this.field_147003_i + 283 + 45, this.field_147009_r + 112, 43, 20, "gui.remove", this.scrollTags.getSelected() != null);
        button.setHoverText("drop.hover.tag.del", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(9, this.field_147003_i + 283 + 91, this.field_147009_r + 112, 43, 20, "selectServer.edit", this.scrollTags.getSelected() != null);
        button.setHoverText("drop.hover.tag.edit", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(10, this.field_147003_i + 329, this.field_147009_r + 169, 87, 20, new String[]{"stats.normal", "inv.auto", "inv.inventory"}, this.drop.lootMode);
        button.setEnabled(!this.drop.item.isEmpty());
        button.setHoverText("drop.hover.mode", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(11, this.field_147003_i + 329, this.field_147009_r + 192, 87, 20, new String[]{"drop.type.random", "drop.type.level"}, this.drop.tiedToLevel ? 1 : 0);
        button.setEnabled(!this.drop.item.isEmpty());
        button.setHoverText("drop.hover.tied", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(anyIDs, "global.quests", this.field_147003_i + 229, this.field_147009_r + 197));
        int qid = Math.max(this.drop.questId, 0);
        GuiNpcTextField textField = new GuiNpcTextField(4, (GuiScreen)this, this.field_147003_i + 268, this.field_147009_r + 192, 50, 20, "" + qid);
        textField.setMinMaxDefault(0L, Integer.MAX_VALUE, qid);
        this.addTextField(textField);
        this.addButton(new GuiNpcButton(12, this.field_147003_i + 171, this.field_147009_r + 191, 48, 20, "availability.select", !this.drop.item.isEmpty()));
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int mouseBottom) {
        if (this.isMouseHover(mouseX, mouseY, this.field_147003_i, this.field_147009_r - 20, this.field_146294_l, 20)) {
            this.close();
        } else {
            super.func_73864_a(mouseX, mouseY, mouseBottom);
        }
    }

    @Override
    public void save() {
        GuiNpcTextField.unfocus();
        if (this.slot == -1) {
            if (this.drop.item.isEmpty()) {
                return;
            }
            if (this.drop.getMinAmount() == 1 && this.drop.getMinAmount() == 1) {
                this.drop.setAmount(this.drop.item.getStackSize(), this.drop.item.getStackSize());
            }
        }
        this.drop.item.setStackSize(1);
        Client.sendData(EnumPacketServer.MainmenuInvDropSave, this.dropType, this.groupId, this.slot, this.drop.getNBT());
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        if (!scroll.hasSelected()) {
            return;
        }
        GuiNpcTextField.unfocus();
        switch (scroll.getID()) {
            case 0: {
                this.enchant = this.enchantData.get(scroll.getSelected());
                break;
            }
            case 1: {
                this.attribute = this.attributesData.get(scroll.getSelected());
                break;
            }
            case 2: {
                this.tag = this.tagsData.get(scroll.getSelected());
            }
        }
        this.func_73866_w_();
    }

    @Override
    public void scrollDoubleClicked(String selection, IGuiCustomScroll scroll) {
        switch (scroll.getID()) {
            case 0: {
                this.setSubGui(new SubGuiDropEnchant(this.enchant));
                break;
            }
            case 1: {
                this.setSubGui(new SubGuiDropAttribute(this.attribute));
                break;
            }
            case 2: {
                this.setSubGui(new SubGuiDropValueNbt(this.tag));
            }
        }
    }

    @Override
    public void subGuiClosed(SubGuiInterface subgui) {
        if (subgui instanceof SubGuiDropEnchant) {
            SubGuiDropEnchant gui = (SubGuiDropEnchant)subgui;
            this.enchant.load(gui.enchant.getNBT());
        } else if (subgui instanceof SubGuiDropAttribute) {
            SubGuiDropAttribute gui = (SubGuiDropAttribute)subgui;
            if (gui.attribute.getAttribute().isEmpty()) {
                this.drop.removeAttribute(this.attribute);
            } else {
                this.attribute.load(gui.attribute.getNBT());
            }
        } else if (subgui instanceof SubGuiDropValueNbt) {
            SubGuiDropValueNbt gui = (SubGuiDropValueNbt)subgui;
            if (gui.tag.getPath().isEmpty() || gui.tag.getValues().length == 0) {
                this.drop.removeDropNbt(this.tag);
            } else {
                this.tag.load(gui.tag.getNBT());
            }
        } else if (subgui instanceof GuiQuestSelection && ((GuiQuestSelection)subgui).selectedQuest != null) {
            this.drop.questId = ((GuiQuestSelection)subgui).selectedQuest.id;
        }
        this.func_73866_w_();
    }

    @Override
    public void unFocused(IGuiNpcTextField textField) {
        switch (textField.getID()) {
            case 0: {
                this.drop.setChance(textField.getDouble());
                break;
            }
            case 1: {
                this.amount[0] = textField.getInteger();
                this.drop.setAmount(this.amount[0], this.amount[1]);
                break;
            }
            case 2: {
                this.amount[1] = textField.getInteger();
                this.drop.setAmount(this.amount[0], this.amount[1]);
                break;
            }
            case 3: {
                this.drop.setDamage((float)textField.getDouble());
                break;
            }
            case 4: {
                this.drop.questId = textField.getInteger();
            }
        }
    }
}

